<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Add your custom language here. This will never be overwritten by updates.
    |--------------------------------------------------------------------------
    |
    | If you would like to change any language text, please copy the key here from the default.php
    |
    */


    /*
    |--------------------------------------------------------------------------
    | calender_language_set use this variable to set calender language
    |--------------------------------------------------------------------------
    */


    "calender_language_set" => "en",

    //home page
    "welcome_to_gain_booking" => "Welcome to Gain Booking",
    "home_page_welcome_message" => "We are Gain Booking system to serve you better and easier services. From here you can book your required servises as your choosing time slot as well as your demanded quantity. Select any one service listed below. Following some easy procedure you can book our service by your own. We support your happy booking.",

    // Buttons
    "details" => "Detalles",
    "submit" => "Enviar",
    "save" => "Guardar",
    "add" => "Agregar",
    "edit" => "Editar",
    "confirm" => "Confirmar",
    "cancel" => "Cancelar",
    "close_btn" => "Cerrar",
    "yes" => "Sí",
    "x_clear" => "clear",
    "clear_language_cache" => "Borrar caché de idioma",
    "apps_language_successfully_updated" => "Idioma actualizado correctamente.",
    "the_language_cache_has_been_removed" => "El caché de idioma se ha eliminado.",

    // Warning
    "are_you_sure" => "¿Estás segura?",
    "app_title" => "Obtener reserva",
    "login" => "Iniciar sesión",
    "login_here" => "Inicie sesión aquí",
    "login_email" => "Usuario",
    'email_or_phone' => "Email o teléfono",
    "login_password" => "Contraseña",
    "forgot_password" => "¿Olvidó su contraseña?",
    "dont_have_account" => "¿No tiene una cuenta?",
    "sign_up" => "Registrarse",
    "back_to" => "Volver a",
    "back_to_home" => "Volver a Inicio",
    "back_" => "Atrás",
    "hi_there" => "¡Hola!",
    "sign_in_to_your_dashboard" => "Inicie sesión en su panel.",
    "sign_up_for_your_new_account" => "Regístrese para su nueva cuenta.",

    'failed' => 'Estas credenciales no coinciden con nuestros registros.',
    'throttle' => 'Demasiados intentos de inicio de sesión. Inténtalo de nuevo en unos segundos.',

    'password' => 'Las contraseñas deben tener al menos seis caracteres y coincidir con la confirmación.',
    'reset' => '¡Su contraseña ha sido restablecida!',
    'sent' => '¡Hemos enviado su enlace de restablecimiento de contraseña por correo electrónico!',
    'token' => 'Este token de restablecimiento de contraseña no es válido.',
    'user' => "No podemos encontrar un usuario con esa dirección de correo electrónico.",

    'previous' => '&laquo; Anterior',
    'next' => 'Siguiente &raquo;',

    "have_not_permission_to_login" => "¡No tiene permiso suficiente para iniciar sesión!",
    "registration_is_disabled" => "¡El registro está desactivado ahora! Inténtalo de nuevo más tarde ..",

    // Booking Error Message
    'choose_available_time_slot' => '¡Elija cualquier intervalo de tiempo disponible de la lista anterior!',
    'booking_seat_can_not_be_zero' => "¡La reserva no se puede procesar para cero sillas!",
    'please_select_a_date' => 'Seleccione una fecha',

    "first_name" => "Nombre",
    "first_name_small" => "nombre",
    "last_name_small" => "apellidos",
    "last_name" => "Apellidos",
    "full_name" => "Nombre Completo",
    "confirm_password" => "Confirmar contraseña",
    "confirm_password_small" => "confirmar contraseña",
    "already_have_an_account?" => "¿Ya tienes una cuenta?",
    "register_at" => "Registrado en",
    "please_choose_one" => "Seleccione una opción",
    "phone" => "Teléfono",
    "enter_phone" => "Ingresar teléfono",
    "you_are_registered_now" => "¡Ya estás registrado!",

    // Controlador de inicio de sesión
    "inactive_invalid_email" => "El correo electrónico no es válido o necesita verificar su dirección de correo electrónico",
    "invalid_login" => "Correo electrónico o contraseña no válidos",
    "have_you_forgot_your_password" => "¿Olvidó su contraseña?",
    "click_here" => "Haga clic aquí",

    // Controlador de autenticación
    "account_already_verified" => "Cuenta ya verificada ...",
    "successful_verified" => "Ha verificado correctamente su dirección de correo electrónico",
    "verification_code_invalid" => "El código de verificación no es válido",
    "email_not_found" => "No se encontró su dirección de correo electrónico",
    "password_reset" => "Su enlace de restablecimiento de contraseña",
    "reset_email_send" => "¡Se ha enviado un correo electrónico de reinicio! Revise su correo electrónico",

    // Registrar controlador
    "registration_confirmation" => "Confirmación de registro",
    "password_is_required" => "Se requiere contraseña",
    "password_must_be_at_least_6_characters" => "La contraseña debe tener al menos 6 caracteres",
    "confirm_password_is_required" => "Confirmar que se requiere contraseña",
    "passwords_must_match" => "Las contraseñas deben coincidir",
    "account_verification" => "Verificación de cuenta",
    "confirm_email_send" => "Se ha enviado un correo electrónico de confirmación. Revise su correo electrónico",
    "Activation_completed" => "Su activación se ha completado",
    "something_wrong" => "¡Vaya, algo salió mal!",

    // Controlador de usuario API
    "verificar_email" => "No podemos encontrar una cuenta con estas credenciales. Asegúrese de haber ingresado la información correcta y de haber verificado su dirección de correo electrónico",
    "logout" => "Ha cerrado la sesión correctamente",
    "logout_failed" => "Error al cerrar sesión, por favor intente nuevamente",
    "signup_welcome" => "¡Gracias por registrarse! Revise su correo electrónico para completar su registro",
    "error_update" => "Error durante la actualización",
    "update_successful" => "Actualizado correctamente",
    "delete_fail" => "Error al eliminar",
    "delete" => "Delete",
    "successful_saved" => "Guardado correctamente",
    "successful_deleted" => "Eliminado correctamente",
    "booking_deleted_successfully" => "La reserva se ha eliminado correctamente",
    "booking_saved_successfully" => "La reserva se ha guardado correctamente",

    "getting_problems" => "¡Opps, algo salió mal!",
    "this_title_already_taken" => "Este título ya está en uso",

    // Información del perfil
    "profile_title" => "Mi perfil",
    "date_of_birth" => "Fecha de nacimiento",
    "gender" => "Gender",
    "choose_one" => "Elija uno",
    "male" => "Male",
    "female" => "Female",
    "others" => "Otros",
    "change_profile_image" => "Cambiar imagen de perfil",
    "image_only" => "Elegir solo imágenes",
    "profile_update_success" => "El perfil se ha actualizado correctamente",
    "profile" => "Perfil",
    "my_profile" => "Mi perfil",

    // Actualización de cuenta
    "account_update" => "Actualización de cuenta",

    // Contáctenos
    "your_message_send_successfully" => "¡Gracias! Su mensaje se envió correctamente",

    //Restablecer la contraseña
    "enter_email_address" => "Ingrese su dirección de correo electrónico para restablecer su contraseña",
    "enter_email_or_phone" => "Ingrese correo electrónico o teléfono",
    "enter_email" => "Ingresar correo electrónico",
    "enter_password" => "Ingresar contraseña",
    "enter_first_name" => "Ingrese el nombre",
    "enter_last_name" => "Ingrese el apellido",
    "send" => "Enviar",
    "reset_password" => "Restablecer contraseña",
    "new_password" => "Nueva contraseña",
    "change_password" => "Cambiar contraseña",
    "password_not_match" => "La confirmación de la contraseña no coincide",
    "password_updated_successfully" => "La contraseña se actualizó correctamente",
    "please_enter_your_email" => "Ingrese su correo electrónico",

    // Configuraciones de la aplicación
    "application_settings" => "Configuración de la aplicación",
    "application_settings_successfully_saved" => "La configuración de la aplicación se ha actualizado correctamente",
    "apps_successfully_update" => "La configuración de la aplicación se ha actualizado correctamente",
    "choose_currency" => "Elegir moneda",
    "date_time_options" => "Configuración de fecha y hora",
    "time_format" => "Formato de hora",
    "24h" => "24h",
    "12h" => "12h",
    "date-format" => "Date format",
    "dd/mm/yyyy" => "DD/MM/YYYY",
    "mm/dd/yyyy" => "MM/DD/YYYY",
    "yyyy/mm/dd" => "YYYY/MM/DD",
    "dd-mm-yyyy" => "DD-MM-YYYY",
    "mm-dd-yyyy" => "MM-DD-YYYY",
    "yyyy-mm-dd" => "YYYY-MM-DD",
    "dd_mm_yyyy" => "DD.MM.YYYY",
    "mm_dd_yyyy" => "MM.DD.YYYY",
    "yyyy_mm_dd" => "YYYY.MM.DD",
    "d mmmm, yyyy" => "d mmmm, yyyy",
    "currency_settings" => "Configuración de moneda",
    "currency_symbol" => "Símbolo de moneda",
    "currency_position" => "Posición de moneda",
    "mil_separador" => "Mil separadores",
    "decimal_separator" => "Separador decimal",
    "number_of_decimal" => "Número de decimales",
    "language_settings" => "Configuración de idioma",
    "english" => "inglés",
    "preferred_language" => "Idioma preferido",
    "application" => "Aplicación",
    "emails" => "Correo electrónico",
    "email_template" => "Plantilla de correo electrónico",
    "off_day" => "Descanso",
    "choose_off_day" => "Selecciona los dias",
    "holidays" => "Holidays",
    "users" => "Users",
    "app_name" => "Nombre de la aplicación",
    "change_application_logo" => "Cambiar el logotipo de la aplicación",
    "change_background_image" => "Cambiar imagen de fondo",
    "restore_default" => "Restaurar a los valores predeterminados",
    "landing_page_settings" => "Configuración de la página de destino",
    "time_zone" => "Timezone",
    "change_app_logo" => "Cambiar el logotipo de la aplicación",
    "business_type_setting" => "Configuración de tipo de empresa",
    "choose_business_type" => "Elegir tipo de empresa",
    "general" => "General",
    "salon" => "Salon",
    "time_and_date_settings" => "Configuración de hora y fecha",
    "copyright_text" => "Texto de copyright",
    "placeholder_choose_background_image" => "1900 x 400 px recomendado",
    "placeholder_choose_app_logo" => "120 x 50 px recomendado",
    "admin_notification_for_booking_request" => "Notificación de administrador para solicitud de reserva",


    // Configuración del cliente
    "clients" => "Clientes",
    "client" => "Cliente",
    "client_settings" => "Configuración del cliente",
    "client_can_signup" => "El cliente puede registrarse",
    "auto_approve_client_registration" => "Aprobar automáticamente el registro del cliente",
    "client_can_login" => "El cliente puede iniciar sesión",
    "client_can_submit_booking_when_login" => "El cliente puede enviar la reserva solo después de iniciar sesión",
    "invalid_mail" => "Dirección de correo electrónico no válida",



    //Información del contacto
    "contact_information" => "Información de contacto",
    "edit_contact_information" => "Editar información de contacto",
    "sub_title" => "Subtítulo",
    "address" => "Dirección",
    "contact_email" => "Correo electrónico",
    "contact_information_saved_successfully" => "La información de contacto se guardó correctamente",
    "contact_information_updated_successfully" => "Información de contacto actualizada correctamente",
    "contact_information_successfully_deleted" => "La información de contacto se eliminó correctamente",
    "delete_contact_info" => "Esta información de contacto se eliminará de forma permanente",
    "your_email_here" => "Su correo electrónico aquí",
    "your_text_here" => "Su texto aquí",
    "subject" => "Asunto",


    // Servicios
    "service_buffering_time" => "Tiempo de almacenamiento en búfer del servicio",
    "Duration" => "Duración",
    "comienza" => "Comienza",
    "ends" => "Finaliza",
    "search" => "Buscar",
    "active" => "Active",
    "inactive" => "Inactive",
    "service_details" => "Detalles del servicio",
    "Visitors_details" => "Detalles de los visitantes",
    "add_service" => "Agregar servicio",
    "price" => "Price",
    "price_per_space" => "Precio por espacio",
    "service_duration" => "Duración del servicio",
    "multiple_bookings" => "Permitir múltiples reservas",
    "description" => "Descripción",
    "min_booking" => "Reserva mínima",
    "max_booking" => "Reserva máxima",
    "update_service" => "Servicio de actualización",
    "allow_cancel" => "Permitir cancelar",
    "auto_confirm" => "Confirmación automática",
    "available_seat" => "Espacio disponible por servicio",
    "available_space_space_field_is_required" => "El campo de espacio disponible es obligatorio",
    "activación" => "Activo",
    "is_default" => "Predeterminado",
    "time_slot" => "Time Slot",
    "no_slots_available" => "No hay espacios disponibles, cambie",
    "setting_service" => "Configuración del servicio",
    "no" => "No",
    "select_service" => "Seleccionar servicio",
    "service_deleted_permanently" => "Este servicio se eliminará de forma permanente",
    "setting" => "Configuración",
    "deactivate" => "Desactivar",
    "activar" => "Activar",
    "service_duration_type" => "Tipo de duración del servicio",
    "daily" => "Daily",
    "cada hora" => "cada hora",
    "service_starting_date" => "Fecha de inicio del servicio",
    "service_ending_date" => "Fecha de finalización del servicio",
    "service_successfully_updated" => "El servicio se ha guardado correctamente",
    "cannot_be_equal_or_less_than_start" => "No puede ser igual o menor que la hora de inicio del Servicio",
    "service_duration_cannot_be_0_mins" => "La duración del servicio no puede ser de 00 minutos",
    "enabled" => "Activated",
    "deactivated" => "Desactivado",
    "service_policy" => "Política de servicio",
    "our_service" => "Nuestro servicio",
    "service_policy_successfully_saved" => "La política de servicio se ha guardado correctamente",
    "service_policy_successfully_update" => "La política de servicio se ha actualizado correctamente",
    "change_service_policy" => "Cambiar política de servicio",
    "delete_service_policy" => "Esta política de servicio se eliminará de forma permanente",
    "service_policy_successfully_delete" => "La política de servicio se ha eliminado correctamente",
    "consider_children_for_price" => "Considerar a los niños por precio",
    "consider_children_for_price_small" => "considerar a los niños por precio",
    "age_range" => "Rango de edad",
    "age_range_small" => "rango de edad",
    "service_small" => "service",
    "ziro" => "0 -",
    "años" => "años",
    "porcentaje" => "Porcentaje",
    "employee" => "Empleado",
    "capacidad" => "Capacidad",
    "percent_sing" => "%",
    "closed" => "Cerrado",
    "service_duration_limit_crossed" => "Límite de duración del servicio cruzado",
    "Recommended_service_image" => "Se recomienda 350 x 200 px",
    "service_deleted_successfully" => "El servicio se ha eliminado correctamente",



    //vínculo social
    "social_link" => "Social Link",
    "social_links" => "Enlaces sociales",
    "social_link_update" => "El enlace social se ha actualizado correctamente",
    "google_plus_small" => "google plus",
    "facebook" => "Facebook",
    "instagram" => "Instagram",
    "linkedin" => "Linkedin",
    "twitter" => "Twitter",
    "google_plus" => "Google Plus",
    "youtube" => "Youtube",
    "pinterest" => "Pinterest",
    "tumblr" => "Tumblr",
    "flickr" => "Flickr",

    // Reservaciones
    "booking" => "Reservas",
    "booking_history" => "Historial de reservas",
    "all_bookings" => "Todas las reservas",
    "add_booking" => "Agregar reserva",
    "phone_number" => "Número de teléfono",
    "comment" => "Comentario",
    "service" => "Servicio",
    "view" => "View",
    "book" => "Book",
    "booking_id" => "Id. de reserva",
    "service_id" => "Id. de servicio",
    "status" => "Estado",
    "booking_date" => "Fecha de reserva",
    "booking_time" => "Tiempo de reserva",
    "quantity" => "Cantidad",
    "reserved_by" => "Reservado por",
    "successfully_booked" => "Booked Successfully.",
    "service_ends" => "Service ends",
    "service_starts" => "Service starts",
    "drag_and_drop_an_image" => "Arrastra y suelta una imagen",
    "persona" => "Persona",
    "limited_seat" => "No podemos reservar más que el asiento disponible",
    "bill" => "Bill",
    "please_wait_while" => "Espere mientras se procesa su reserva ...",
    "booking_submitted_successfully" => "Su reserva se ha enviado correctamente",
    "ok" => "Ok",
    "booking_not_submitted" => "Su reserva no se envió correctamente",
    "please_try_again" => "Inténtelo de nuevo",
    "bookingconfirmed" => "Confirmado",
    "bookingcanceled" => "Cancelado",
    "bookingpending" => "Pendiente",
    "booking_at" => "Reservado en",
    "shown_at" => "Recibido en",
    "id" => "ID",
    "book_date" => "Fecha",
    "time" => "Time",
    "allow_booking_max_day_ago" => "Permitir reserva máxima",
    "days_ago" => "hace días",
    "you_cant_book" => "No puedes reservar sin iniciar sesión",
    "bookings" => "Reservas",
    "multiple_booking" => "Reserva múltiple",
    "multiple_booking_yes" => "Puede seleccionar varios intervalos de tiempo disponibles de la lista a continuación",
    "multiple_booking_no" => "Solo puede seleccionar un intervalo de tiempo de la lista a continuación",
    "please_provide_your_details" => "Complete sus datos para proceder con la reserva:",
    "your_details" => "Sus detalles:",
    "please_choose_a_payment_method" => "Elija un método de pago a continuación",
    "your_payment_is_not_successful" => "¡Lo sentimos! Su pago no se realizó correctamente. Inténtelo de nuevo",
    "book_time" => "Time",
    "every_time_slot_provide_you" => "Cada intervalo de tiempo le proporciona",
    "hora" => "hora",
    "minute" => "minute",
    "horas" => "horas",
    "minutes" => "minutes",
    "daily_service_booking" => "",
    "next_" => "Siguiente",
    "number_of_item_you_want_to_book" => "Número de elemento que desea reservar",
    "number_of_seat_you_book" => "Número de asientos que reserva",
    "no_space_available" => "No hay espacio disponible",
    "thank_you" => "Gracias",
    "booking_is_processing" => "La reserva se está procesando ...",
    "admin_booking_submitted_successfully" => "La reserva se ha agregado correctamente",
    "total_bookings" => "Total de reservas",
    "your_desired_quantity" => "Su cantidad deseada",
    "number_of_bookings" => "Número de reservas",
    "please_login_and_try_again" => "Inicie sesión e intente nuevamente",
    "not_selected_yet" => "No seleccionado aún",
    "booking_confirmed" => "Reserva confirmada",
    "booking_canceled" => "Reserva cancelada",
    "delete_custom_filed" => "Este archivo personalizado se eliminará de forma permanente",
    "booking_will_be_canceled" => "Esta reserva será cancelada",
    "booking_will_be_deleted_permanently" => "Esta reserva se eliminará de forma permanente",

    // filtro de reserva
    "cancelado" => "Cancelado",
    "confirm_" => "Confirmado",
    "pendiente" => "Pendiente",
    "booking_is_canceled" => "La reserva se ha cancelado correctamente",
    "booking_is_confirmed" => "La reserva ha sido confirmada con éxito",
    "all" => "Todos",
    "today" => "Hoy",
    "ayer" => "Ayer",
    "next_7_days" => "Próximos 7 días",
    "this_month" => "Este mes",
    "this_year" => "Este año",
    "this_Month" => "Este mes",

    // Roles
    "roles" => "Roles",
    "role" => "Role",
    "role_title" => "Título del rol",
    "role_deleted_permanently" => "Esta función se eliminará de forma permanente",
    "roles_deleted_successfully" => "El rol se ha eliminado correctamente",
    "roles_saved_successfully" => "El rol se ha guardado correctamente",
    "roles_updated_successfully" => "El rol se ha actualizado correctamente",
    "edit_role" => "Editar rol",
    "add_role" => "Agregar rol",
    "role_is_used" => "Esta función se utiliza, no puede eliminarla",
    "can_manage_application_setting" => "Puede administrar la configuración de la aplicación",
    "can_manage_email_setting" => "Puede administrar la configuración del correo electrónico",
    "can_manage_offday_setting" => "Puede administrar la configuración del día",
    "can_manage_holiday_setting" => "Puede administrar la configuración de vacaciones",
    "can_manage_service" => "Puede administrar el servicio",
    "can_add_booking_for_users" => "Puede agregar reserva para usuarios",
    "can_manage_booking" => "Puede administrar la reserva",
    "can_manage_email_template" => "Puede administrar la plantilla de correo electrónico",
    "can_manage_client_settings" => "Puede administrar la configuración del cliente",
    "can_manage_client" => "Puede administrar el cliente",
    "can_manage_payment_methods" => "Puede administrar métodos de pago",
    "can_manage_custom_input" => "Puede administrar campos personalizados",
    "admin" => "Admin",
    "admin_can_not_be_update" => "El administrador no se puede actualizar",

    //Ajustes del correo electrónico
    "email_settings" => "Configuración de correo electrónico",
    "application_name" => "Correo electrónico enviado desde el nombre",
    "email_address" => "Dirección de correo electrónico",
    "email_driver" => "Controlador de correo electrónico",
    "host" => "Host",
    "port" => "Puerto",
    "encryption_type" => "Tipo de cifrado",
    "password_email_settings" => 'Contraseña para acceder',
    "test_mail" => "Probar correo electrónico",
    "test_send" => "Test Sned",
    "test_email_sent" => "Se envía un correo electrónico de prueba",
    "email_settings_successfully_saved" => "La configuración del correo electrónico se ha guardado correctamente",
    "email_settings_successfully_saved _ & _ test_mail_is_sent" => "La configuración del correo electrónico se guardó correctamente y el correo electrónico de prueba se envió",
    "type_mail_address_to_check_email_config" => "Escriba una dirección de correo electrónico si desea verificar la configuración del correo electrónico",
    "smtp" => "SMTP",
    "sendmail" => "Enviar correo electrónico",
    "tls" => "TLS",
    "ssh" => "SSH",
    "email_not_sent" => "¡No se puede enviar correo electrónico! Compruebe la configuración del correo electrónico",

    // Configuración de vacaciones
    "title" => "Título",
    "start_date" => "Fecha de inicio",
    "end_date" => "Fecha de finalización",
    "action" => "Acción",
    "add_holiday" => "Agregar vacaciones",
    "edit_holiday" => "Editar vacaciones",
    "update_holiday" => "Actualizar vacaciones",
    "didnt_find" => "No encontramos nada que mostrar aquí",
    "fill_required_fields" => "Rellene los campos obligatorios",
    "holiday_title" => "Título de vacaciones",
    "holiday_will_be_deleted" => "Este feriado se eliminará de forma permanente",
    "holiday_deleted_successfully" => "Las vacaciones se han eliminado con éxito",
    "holiday_successfully_saved" => "Las vacaciones se guardaron correctamente",
    "holiday_successfully_update" => "Las vacaciones se han actualizado correctamente",
    "cannot_be_less_than_start_date" => "No puede ser inferior a la fecha de inicio",
    "end_date_cannot_be_less_than_start_date" => "La fecha de finalización no puede ser inferior a la fecha de inicio",

    // Plantilla de correo electrónico
    "user_invitation" => "Invitación de usuario",
    "user_registration" => "Registro de usuario",
    "booking_confirmation" => "Confirmación de reserva",
    "booking_received" => "Reserva recibida",
    "email_templates" => "Plantillas de correo electrónico",
    "subject" => "Asunto",
    "subject_small" => "subject",
    "content" => "Contenido",
    "booking_rejected" => "Reserva rechazada",
    "type" => "Type",
    "email_templates_successfully_update" => "La plantilla de correo electrónico se actualizó correctamente",
    "email_template_restored_to_default" => "La plantilla de correo electrónico se ha restaurado a los valores predeterminados",

    // Off Day Setting
    "off_day_settings" => "Ajustar dias de cierre",
    "off_days" => "Cuando cerramos",
    "sunday" => "Domingo",
    "monday" => "Lunes",
    "tuesday" => "Martes",
    "wednesday" => "Miercoles",
    "thursday" => "Jueves",
    "friday" => "Viernes",
    "saturday" => "Sabado",
    "offday_successfully_saved" => "Has cambiado los dias de cierre.",

    // barra de navegación
    "dashboard" => "Dashboard",
    "services" => "Servicios",
    "reports" => "Informes",
    "settings" => "Configuración",
    "logout_nv" => "Cerrar sesión",
    "your_notifications" => "Sus notificaciones",
    "view_all" => "Ver todo",

    "required_input_field" => "Este campo es obligatorio",
    "invalid_email" => "Dirección de correo electrónico no válida",

    // Lista de usuarios
    "user_list" => "Lista de usuarios",
    "invite_user" => "Invitar usuario",
    "invite_button" => "Invitar",
    "invite_as" => "Invitar como",
    "invitation_sent_to" => "La invitación ha sido enviada a",
    "invitation_error" => "Verifique la configuración del correo electrónico",
    "name" => "Name",
    "change_user_role" => "Cambiar rol de usuario",
    "user_successfully_saved" => "El usuario se ha guardado correctamente",
    "user_disable_successfully" => "El usuario se ha deshabilitado correctamente",
    "user_enable_successfully" => "El usuario se ha habilitado correctamente",
    "this_user_will_be_disabled" => "Este usuario estará deshabilitado",
    "this_user_will_be_enabled" => "Este usuario estará habilitado",


    // Tablero
    "total_booking_for_next_30_days" => "Reservas totales para los próximos 30 días",
    "confirm_booking_for_next_30_days" => "Reservas confirmadas para los próximos 30 días",
    "today_total_booking" => "Reservas totales de hoy",
    "today_pending_booking" => "Reservas pendientes de hoy",
    "booking_overview" => "Descripción general de la reserva",
    "last_12_months" => "Este año",
    "booking_type" => "Estado de la reserva",
    "total_bookings_of_different_services" => "% de reserva confirmada y pendiente de hoy",
    "total_booking" => "Total de reservas",
    "last_month" => "Último mes",
    "till_now" => "Hasta ahora",
    "bookings" => "Reservas",
    "my_account" => "Mi cuenta",

    // Mensaje del controlador
    "error_during_update" => "Error durante la actualización",
    "permission_updated" => "Permiso actualizado",
    "permission_error" => "Error de permiso",
    "permission_is_not_available" => "El permiso no está disponible",
    "created_successfully" => "El servicio se ha guardado correctamente",
    "service_updated_successfully" => "El servicio se actualizó correctamente",
    "error_during_creating" => "Error durante la creación",
    "registration_done" => "Su registro ha finalizado",
    "notify_open" => "Notificación abierta",
    "password_updated" => "Contraseña actualizada",
    "successful_updated" => "Actualizada con éxito",
    "deleted_successfully" => "Eliminado correctamente",
    "error_during_deleted" => "Error durante la eliminación",
    "the_email_has_already_been_taken" => "El correo electrónico ya se ha tomado",

    "date_range" => "Rango de fechas",
    "costumbres" => "Personalizado",
    "user_in_use" => "Usuario en uso",
    "user_will_be_deleted_permanently" => "El usuario se eliminará de forma permanente",
    "deleted_permanently" => "Eliminado permanentemente",

    // notificaciones
    "notificación" => "Notificación",
    "notificaciones" => "Notificaciones",
    "all_notifications" => "Todas las notificaciones",
    "booking_notification" => "Notificación de reserva",
    "you_have_no_notifications" => "No tiene notificaciones",
    "submit_a_new_booking" => "envió una nueva reserva",
    "shown_the_booking" => "confirmó la reserva",
    "canceled_the_booking" => "canceló la reserva",

    // clientes
    "client_dashboard" => "Panel de cliente",
    "new_booking" => "Nueva reserva",
    "all_clients" => "Todos los clientes",
    "client_details" => "Detalles del cliente",
    "booking_list" => "Lista de reservas",
    "booking_active" => "Reserva exitosamente activa",
    "booking_cancel" => "Cancelar reserva",
    "booking_details" => "Detalles de la reserva",
    "view_booking" => "Ver reserva",
    "client_setting_saved_successfully" => "La configuración del cliente se ha guardado correctamente",
    "client_updated_successfully" => "El cliente se ha actualizado correctamente",
    "client_deleted_successfully" => "El cliente se ha eliminado correctamente",
    "client_in_use" => "Cliente en uso",
    "client_will_be_deleted_permanently" => "El cliente se eliminará de forma permanente",

    //Informes
    "available" => "Disponible",
    "confirm_booking" => "Reservas confirmadas",
    "nding_booking "=>" Reservas pendientes ",
    "can_see_reports" => "Puede ver informes",

    // Tabla de datos
    "load_more" => "Cargar más",

    // Ajustes básicos
    "general_settings" => "Configuración general",
    "rows_per_table" => "Número de filas por tabla",
    "created_at '=>' Creado en",

    "sign_in" => "Iniciar sesión",

    "booking_pending" => "Reserva pendiente",
    "booking_confirm" => "Confirmación de reserva",
    "Recent_bookings" => "Reservas recientes",
    "created_at" => "Creado en",
    "register" => "Registrarse",

    //Métodos de pago
    "payment_methods" => "Métodos de pago",
    "add_payment_method" => "Agregar método de pago",
    "edit_payment_method" => "Editar método de pago",
    "available_to_client" => "Disponible para el cliente",
    "true" => "True",
    "false" => "False",
    "enabled" => "Enabled",
    "disabled" => "Disabled",
    "enable" => "Enable",
    "disable" => "Desactivar",
    "secret_key" => "Clave secreta",
    "publishablekey" => "Clave publicable",
    "client_secret" => "Secreto del cliente",
    "google_calendar_save_successfully" => "Calendario de Google guardado correctamente",
    "invalid_google_calendar_credentials" => "Credenciales de calendario de Google no válidas",
    "cant_connect_google_calender_using_this_credentials" => "No se puede conectar el calendario de Google con estas credenciales",
    "payment_method_saved_successfully" => "El método de pago se ha guardado correctamente",
    "payment_method_updated_successfully" => "El método de pago se ha actualizado correctamente",
    "payment_method_deleted_permanently" => "El método de pago se eliminará de forma permanente",
    "payment_method_deleted_successfully" => "El método de pago se ha eliminado correctamente",
    "payment_done_successfully" => "El pago se ha guardado correctamente",
    "payment_methods_" => "Métodos de pago",

    // pagos
    "payment_status" => "Estado de pago",
    "due" => "Due",
    "paid" => "Paid",
    "pay" => "Pay",
    "due_payment" => "Pago vencido",
    "payment_amount" => "Importe del pago",

    // Entrada personalizada
    "custom_fields" => "Campos personalizados",
    "custom_field_settings" => "Configuración de campo personalizado",
    "list_view" => "Vista de lista",
    "datatable_view" => "Vista de tabla de datos",
    "add_custom_field" => "Agregar campo personalizado",
    "edit_custom_field" => "Editar campo personalizado",
    "field_type" => "Tipo de campo",
    "field_input_types" => "Entrada",
    "select" => "Seleccionar",
    "textarea" => "Texto largo",
    "input_type" => "Tipo de entrada",
    "text" => "Texto",
    "input_email" => "Correo electrónico",
    "checkbox" => "casilla de verificación",
    "input_file" => "Archivo",
    "input_date" => "Fecha",
    "number" => "Number",
    "radio" => "Radio",
    "booking_table" => "Tabla de reservas",
    "service_table" => "Tabla de servicio",
    "table_name" => "Table Name",
    "label_name" => "Etiqueta de entrada",
    "add_options" => "Agregar opciones",
    "options" => "Opciones",
    "enable_field" => "Habilitar campo",
    "field_type_small" => "tipo archivado",
    "custom_field_save_successfully" => "El campo personalizado se ha guardado correctamente",
    "custom_field_update_successfully" => "El campo personalizado se ha actualizado correctamente",
    "show_in_table" => "Mostrar en tabla",
    "show" => "Show",
    "field_type_error" => "Tipo de archivo en uso",
    "archive_in_use" => "El archivado está en uso",
    "delete_service_custom_filed" => "Este servicio personalizado archivado se eliminará",
    "delete_booking_custom_filed" => "Esta reserva personalizada archivada se eliminará",
    "service_delete_custom_filed" => "El servicio personalizado archivado se ha eliminado correctamente",
    "booking_delete_custom_filed" => "La reserva personalizada archivada se ha eliminado correctamente",


    // Actualizaciones
    "updates" => "Actualizaciones",
    "current_version" => "Versión actual",
    "Checking_for_updates" => "Buscando nuevas actualizaciones ...",
    "installation_version" => "Instalación de la versión",
    "available_updates" => "Actualizaciones disponibles",
    "click_to_install_version" => "Haga clic para instalar la versión",
    "backup_reminder" => "¡Haga una copia de seguridad de los archivos y la base de datos de su aplicación antes de instalar una nueva versión!",

    "invalid_purchase_code" => "Código de compra no válido",
    "no_updates_found" => "No se encontraron actualizaciones",
    "install_zip_extension" => "¡Instale la extensión zip en su servidor!",
    'please_install_version' => "Instale la versión", 'first' => 'first!',
    "version" => "Version", 'installation_successfully' => "Instalado correctamente",
    "no_data_found" => "No se encontraron datos",
    "app_not_found" => "Aplicación no encontrada",
    "something_went_wrong" => "Algo salió mal",
    "payment_details" => "Detalles de pago",
    "payment_method" => "Método de pago",
    "payment_by" => "Pago por",
    "payment_info" => "Información de pago",
    "amount" => "Cantidad",
    "sender_email" => "fazlerabbi@gain.media",
    "mandrill" => "Mandrill",
    "type_a_mandrill_api" => "Escriba una API de Mandrill",
    "mandrill_api" => "Mandrill API",
    "sparkpost" => "Sparkpost",
    "sparkpost_api" => "API de Sparkpost",
    "mailgun" => "Mailgun",
    "mailgun_domain" => "Mailgun Domain",
    "mailgun_api" => "API de Mailgun",
    "ses" => "SES",
    "ses_key" => "Clave SES",
    "ses_secret" => "Secreto SES",
    "ses_region" => "Región SES",
    "landing_page_message" => "Mensaje de página de destino",
    "max_landing_page_message" => "(caracteres recomendados 150)",
    "landing_page_header" => "Encabezado de página de destino",
    "contact_us_email" => "Contáctenos correo electrónico",
    "cant_be_less_then_start_date" => "No puede ser menor que la fecha de inicio",
    'shown_by' => 'Recibido por',
    'example_charge' => "Ejemplo de carga",
    'email_setting' => 'Configuración de correo electrónico',
    "error" => "Error",
    'this_is_a_test_email' => 'Este es un correo de prueba',
    "client_bookings" => "Reservas de clientes",
    "contact_information_successfully_updated" => "La información de contacto se ha actualizado correctamente",

    // factura de reserva
    'booking_receipt' => "Recibo de reserva",
    'total' => "Total",
    'reserved_for' => "Reservado para",
    'serial' => "SL #",

    "client_id" => "Id. de cliente",

    // Días semanales
    "sun" => "Dom",
    "mon" => "Lun",
    "tue" => "Mar",
    "wed" => "Mie",
    "thu" => "Jue",
    "fri" => "Vie",
    "sat" => "Sab",

    // Months
    "jan" => "Ene",
    "feb" => "Feb",
    "mar" => "Mar",
    "apr" => "Abr",
    "may" => "May",
    "jun" => "Jun",
    "jul" => "Jul",
    "aug" => "Ago",
    "sep" => "Sep",
    "oct" => "Oct",
    "nov" => "Nov",
    "dec" => "Dic",


    "please_continue_to_process_payment" => "Continúe procesando el pago",
    "mode" => "Modo",
    "sandbox" => "Sandbox",
    "live" => "Live",
    "external_link" => "Enlace externo",
    "and_external_link_already_exists" => "¡y el enlace externo ya existe!",
    "link" => "Link",
    "click_link" => "Copiar enlace",

    'invoice' => 'FACTURA',
    "invoice_to" => "FACTURA A",
    "invoice_id" => "ID de factura",
    "date" => "Date",
    "unit_price" => "Precio unitario",
    "amount_paid" => "Cantidad pagada",
    "balance_due" => "Saldo adeudado",
    "booking_invoice" => "Factura",
    "invoice_settings" => "Configuración de factura",
    "change_invoice_logo" => "Cambiar el logotipo de la factura",
    "choose_jpg_image_only" => "Elegir solo imagen jpg",

    "url_alias" => "URL alias",
    "company_name" => "Nombre de la empresa",
    "company_info" => "Información de la empresa",
    "currency_code" => "Código de moneda",
    "please_use_valid_currency_code" => "Utilice un código de moneda válido como EUR. Se utilizará en métodos de pago en línea ",

    "visible_to_client" => "Visible para el cliente",
    "google_calendar" => "Google Calendar",
    "redirect_url" => "Redirigir URL",
    "required_client_id_field" => "El campo de identificación del cliente es obligatorio",
    "required_client_secret_field" => "El campo secreto del cliente es obligatorio",
    "required_redirect_url_field" => "El campo URL de redireccionamiento es obligatorio",
    "required_label_field" => "El campo de etiqueta de entrada es obligatorio",
    "required_input_type" => "Se requiere el tipo de entrada",
    "please_use_this_url_to_create_your_google_app" => "Utilice esta URL para crear su aplicación de Google",
    "get_your_credentials_from" => "Obtenga sus credenciales de",
    "google_developers_console" => "Consola de desarrolladores de Google",

    // rango de fechas
    "last_7_days" => "Últimos 7 días",
    "last_30_days" => "Últimos 30 días",
    "apply" => "Apply",

    // Forma larga del nombre del mes
    "january" => "enero",
    "february" => "febrero",
    "march" => "marzo",
    "april" => "abril",
    "may" => "mayo",
    "june" => "junio",
    "july" => "julio",
    "august" => "agosto",
    "september" => "septiembre",
    "october" => "octubre",
    "november" => "noviembre",
    "december" => "diciembre",

    // Servicio
    "service_start_field_is_required" => "El campo de inicio del servicio es obligatorio",
    "service_starting_date_field_is_required" => "Se requiere la fecha de inicio del servicio",
    "ending_date_should_not_be_before_than_starting_date" => "La fecha de finalización no debe ser anterior a la fecha de inicio",
    "service_end_field_is_required" => "El campo de finalización del servicio es obligatorio",
    "service_duration_field_is_required" => "El campo de duración del servicio es obligatorio",

    // Reserva de salón
    "home" => "Inicio",
    "contact" => "Contacto",
    "select_number_of_guests" => "Seleccionar número de invitados",
    "adults" => "Adultos",
    "children" => "Niños",
    "no_of_adults" => "Número de adultos",
    "no_of_Children" => "Número de hijos",
    "Select_no_of_guests" => "Seleccionar no de invitados",
    "select_service_assistant" => "Seleccionar asistente de servicio",
    "continue" => "Continuar",
    "service_price" => "Precio del servicio",
    "net_price" => "Precio neto",
    "our_services" => "Nuestros servicios",
    "salon_book_date" => "Fecha",
    "finish" => "Finish",
    "congratulations" => "¡Felicidades!",
    "contact_us" => "Contáctenos",
    "footer_subtitle" => "Nos encantaría saber de usted y quedarnos con nosotros",
    "service_subtitle" => "Puede reservar el servicio desde la vista del carrito fácilmente",
    "you_can_book_service_easily" => "Puede reservar nuestro servicio fácilmente",
    "service_starts_at" => "El servicio comienza en",
    "service_ends_at" => "El servicio finaliza en",
    "service_duration_time" => "Tiempo de duración del servicio",
    "no_of_guest" => "No de invitado",
    "price_per_person" => "Precio / persona",
    "capacity_per_service" => "Capacidad / servicio",
    "visit_us" => "Visítanos",
    "call_us" => "Llámenos",
    "mail_us" => "Envíenos un correo electrónico",
    "change" => "Cambiar",
    "contact_confirm_message" => "¡Gracias por contactarnos! Nos pondremos en contacto con usted pronto.",
    "tooltip_guest_selection_alert" => "Capacidad excedida. Para que pueda seleccionar múltiples intervalos de tiempo ",
    "tooltip_guest_selection_alert_without_multi_booking" => "Capacidad excedida",
    "select_assistant" => "Seleccionar asistente",
    "you_booked_the" => "Ha reservado el",
    "service_at" => "servicio en",
    "on" => "on",
    "with" => "con",
    "costing" => "costing",
    "click_here_to_change_date" => "Haga clic aquí para cambiar la fecha",
    "buy_now" => "Comprar ahora",
    "see_demo" => "Ver demostración",
    "assistant" => "Asistente",
    "gallery" => "Galería",
    "successful_service_booked_message" => "Su reserva se ha enviado correctamente",
    "browse_to_choose_a_file" => "o navegue para elegir un archivo",
    "confirm_payment_message" => "Ya casi has terminado. Verifique un método de pago para pagar el costo del servicio ",
    "hi" => "Hola",

    // version v-1.2
    'select_service_custom_field' => 'If you do not select this field then this custom field will be available for all the services',
    'child' => 'Child',

    //sms setting
    'sms_setting' => 'Sms setting',
    'sms_settings' => 'Sms settings',
    'sms_templates' => 'Sms Templates',
    'sms_templates_successfully_update' => 'Sms template has been updated successfully.',
    'sms_content' => 'Sms Content',
    'sms_send_from_name_phone_number' => 'Sms send from name/phone number',
    'sms_driver' => 'Sms send from name/phone number',
    'nexmo' => 'Nexmo',
    'key' => 'Key',
    'can_manage_sms_setting' => 'Can manage sms setting',
    'either_email_or_phone_is_required' => 'Either email or phone is required',
    'verification_code' => 'Verification code',
    'enter_verification_code' => 'Enter verification code',
    'verify' => 'Verify',
    'verification_successful' => 'Verification successful.',
    'resend_code' => 'Resend code?',
    'verification_code_sent' => 'Verification code sent.',

    // break time settings
    "break_time" => "Break Time",
    "start_time" => "Start Time",
    "end_time" => "End Time",
    "break_time_created_successfully" => "Break time created successfully",
    "break_time_updated_successfully" => "Break time updated successfully",
    "break_time_deleted_successfully" => "Break time deleted successfully",
    "start_time_is_required" => "Start time is required",
    "end_time_is_required" => "End time is required",
    "can_manage_break_time_setting" => "Can manage break time setting",
    "edit_booking" => "Edit Booking",
    "update" => "Update",
    "booking_updated_successfully" => "Booking updated successfully",

    //checked
    "share_available_space_with"=> "Share available space with",

    //Installer
    'database_configuration' => 'Configuración de la base de datos',
    'database_connection' => 'Conexión a la base de datos',
    'enter_database_connection' => 'Ingrese la conexión a la base de datos',
    'database_hostname' => 'Nombre de host de la base de datos',
    'database_port' => 'Puerto de base de datos',
    'database_name' => 'Nombre de la base de datos',
    'database_username' => 'Nombre de usuario de la base de datos',
    'database_password' => 'Contraseña de la base de datos',
    'purchase_code' => 'Código de compra',
    'code' => 'Código',
    'admin_login_details' => 'Detalles de inicio de sesión de administrador',
    'install' => 'Instalar',
    'your' => 'tu',
    "app_installed_successfully" => "Aplicación instalada correctamente",
    "mysql" => "MySQL",
    "pgsql" => "PostgreSQL",
    "sqlsrv" => "SQL Server",
    "enter_database_hostname" => "Ingrese el nombre de host de la base de datos",
    "enter_database_port" => "Ingrese el puerto de la base de datos",
    "enter_database_name" => "Ingrese el nombre de la base de datos",
    "enter_database_username" => "Ingrese el nombre de usuario de la base de datos",
    "enter_database_password" => "Ingrese la contraseña de la base de datos",
    "enter_full_name" => "Ingrese su nombre completo",
    "enter_code" => "Introduzca el código",
    "installer_email" => "Correo electrónico",
    "installer_password" => "Contraseña",
    "database_credential_error" => "Credencial incorrecta de la base de datos!",
    "install_gain_salon_booking" => "Instalar Gain Salon Booking",
    "save_and_next" => "Guardar y siguiente",
];
